<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddKitsModelsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		if (!Schema::hasTable('kits_models')) {
			Schema::create('kits_models', function ($table) {
				$table->increments('id');
				$table->integer('kit_id')->nullable()->default(NULL); 
				$table->integer('model_id')->nullable()->default(NULL);    
				$table->integer('quantity')->default(1);
				$table->timestamps();
			});
		}
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		if (Schema::hasTable('kits_models')) {
			Schema::drop('kits_models');
		}
	}

}
